<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
                    <a href="<?= base_url('admin/ekstrakurikuler/create'); ?>" class="btn btn-success">Tambah Ekstrakurikuler Baru</a>
                </div>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <table class="table table-bordered table-hover" id="data_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Ekstrakurikuler</th>
                            <th>Penanggung Jawab</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; ?>
                        <?php if (!empty($ekskul_list)) : ?>
                            <?php foreach ($ekskul_list as $ekskul) : ?>
                                <tr>
                                    <td><?= $no++; ?></td>
                                    <td><?= esc($ekskul['nama_ekskul']); ?></td>
                                    <td><?= esc($ekskul['penanggung_jawab_nama']); ?></td>
                                    <td>
                                        <a href="<?= base_url('admin/ekstrakurikuler/edit/' . $ekskul['id']); ?>" class="btn btn-primary btn-sm">Edit</a>
                                        <form action="<?= base_url('admin/ekstrakurikuler/delete/' . $ekskul['id']); ?>" method="post" class="d-inline">
                                            <?= csrf_field(); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus ekskul ini?');">Hapus</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="3">Tidak ada data ekstrakurikuler.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
