<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
				<p>Di halaman ini Anda bisa mengelola data kelas, seperti menambah, mengedit, atau menghapus kelas.</p>

				<a href="<?= base_url('admin/kelas/new') ?>" class="btn btn-success" style="margin-bottom: 20px;">Tambah Kelas Baru</a>
				</div>
				</div>
				<div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
				<table class="table table-bordered table-hover" id="data_table"> 
				<thead>
						<tr>
							<th>No</th>
							<th>Nama Kelas</th>
							<th>ID Guru</th>
							<th>Tahun Ajaran ID</th>
							<th>Dibuat Pada</th>
							<th>Diperbarui Pada</th>
							<th>Aksi</th>
						</tr>
					</thead>
					<tbody>
						<?php if (!empty($daftarKelas)): ?>
							<?php $no = 1; foreach ($daftarKelas as $kelas): ?>
							<tr>
								<td><?= $no++ ?></td>
								<td><?= esc($kelas['nama_kelas']) ?></td>
								<td><?= esc($kelas['guru_kelas_id']) ?></td>
								<td><?= esc($kelas['tahun_ajaran_id']) ?></td>
								<td><?= esc($kelas['created_at']) ?></td>
								<td><?= esc($kelas['updated_at']) ?></td>
								<td>
									<a href="<?= base_url('admin/kelas/edit/' . $kelas['id_kelas']) ?>" class="btn btn-primary btn-sm">Edit</a>
									<a href="<?= base_url('admin/kelas/delete/' . $kelas['id_kelas']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus kelas ini?');">Hapus</a>
								</td>
							</tr>
							<?php endforeach; ?>
						<?php else: ?>
							<tr>
								<td colspan="7">Tidak ada data kelas yang tersedia.</td>
							</tr>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?= $this->endSection() ?>