<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
                    <a href="<?= base_url('guru/tp_mapel/create') ?>" class="btn btn-primary mb-3">Tambah TP Baru</a>
                </div>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success">
                        <?= session()->getFlashdata('success') ?>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger">
                        <?= session()->getFlashdata('error') ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($message)) : ?>
                    <div class="alert alert-info"><?= esc($message) ?></div>
                <?php endif; ?>

                <?php if (!empty($kelas_guru)) : ?>
                    <p>Anda terdaftar sebagai guru kelas untuk:
                        <?php $kelas_names = array_column($kelas_guru, 'nama_kelas'); ?>
                        <strong><?= implode(', ', array_map('esc', $kelas_names)) ?></strong>
                    </p>
                <?php else : ?>
                    <p class="alert alert-info">Anda tidak terdaftar sebagai guru kelas.</p>
                <?php endif; ?>

                <?php if (!empty($mapel_guru)) : ?>
                    <p>Anda terdaftar mengampu mata pelajaran:
                        <?php $mapel_names = array_column($mapel_guru, 'nama_mapel'); ?>
                        <strong><?= implode(', ', array_map('esc', $mapel_names)) ?></strong>
                    </p>
                <?php else : ?>
                    <p class="alert alert-warning">Anda belum terdaftar mengampu mata pelajaran apapun.</p>
                <?php endif; ?>
                
                <form action="<?= base_url('guru/tp_mapel') ?>" method="get" class="mb-3">
                    <div class="form-group row align-items-center">
                        <label for="semester_filter" class="col-sm-2 col-form-label">Filter Semester:</label>
                        <div class="col-sm-4">
                            <select name="semester" id="semester_filter" class="form-control">
                                <?php foreach ($semester_options as $option): ?>
                                    <option value="<?= $option ?>" <?= ($selected_semester == $option) ? 'selected' : '' ?>>
                                        <?= $option ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-sm-6">
                            <button type="submit" class="btn btn-info">Filter</button>
                        </div>
                    </div>
                </form>
                
                               <div class="mb-3">
                    <a href="<?= base_url('guru/penilaian/nilaiakhir') ?>" class="btn btn-success">Lihat Nilai Akhir Rapor</a>
                </div>

                <?php if (empty($tp_mapel) && empty($message)) : ?>
                    <div class="alert alert-info">Belum ada Tujuan Pembelajaran yang relevan untuk kelas dan mata pelajaran yang Anda ajar.</div>
                <?php elseif (!empty($tp_mapel)) : ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="data_table">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Mata Pelajaran</th>
                                    <th>Kelas</th>
                                    <th>Semester</th>
                                    <th>Kode TP</th>
                                    <th>Deskripsi TP</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; ?>
                                <?php foreach ($tp_mapel as $tp) : ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($tp['nama_mapel']) ?></td>
                                        <td><?= esc($tp['nama_kelas']) ?></td>
                                        <td><?= esc($tp['semester']) ?></td>
                                        <td><?= esc($tp['kode_tp']) ?></td>
                                        <td><?= esc($tp['deskripsi_tp']) ?></td>
                                        <td>
                                            <a href="<?= base_url('guru/tp_mapel/edit/' . $tp['id']) ?>" class="btn btn-primary mb-3">Edit</a>
                                            <a href="<?= base_url('guru/tp_mapel/delete/' . $tp['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus TP ini?');">Hapus</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>